



EscThrottleCalibration:

	rvsetflagtrue Mode		;true = 2ms output, false = 1.02ms output

esc1:	call LcdClear
	
	lrv PixelType, 1
	lrv FontSelector, f6x8

	lrv X1,0
	lrv Y1,10
	mPrintString esc10

	rvbrflagtrue Mode, esc6
	lrv X1,0			;print footer (i.e. 'EXIT')
	lrv Y1,57
	mPrintString esc13
	call LcdUpdate
	rjmp esc2

esc6:	lrv X1,0
	lrv Y1,30
	mPrintString esc20

	lrv X1,0
	lrv Y1,39
	mPrintString esc21
	call LcdUpdate

	lrv OutputRateBitmask, 0x00	;low rate on all channels
	lrv OutputTypeBitmask, 0x00	;servo type on all channels
	lrv OutputRateDividerCounter, 1
	lrv OutputRateDivider, 8	;slow rate divider. f = 400 / OutputRateDivider
	rvsetflagtrue flagArmed
	b16ldi ServoFilter, 1

	LedOn

	;       76543210		;clear pending OCR1A and B interrupt
	ldi t,0b00000110
	store tifr1, t

	b16ldi Temp, 5000.0		;start with full throttle
	rvsetflagfalse flagThrottleZero

esc2:	call PwmStart
	b16mov Out1, Temp
	b16mov Out2, Temp
	b16mov Out3, Temp
	b16mov Out4, Temp
	b16mov Out5, Temp
	b16mov Out6, Temp
	b16mov Out7, Temp
	b16mov Out8, Temp
	call PwmEnd

	load t, pinb			;read buttons. Cannot use 'GetButtons' here because of delay
	com t
	swap t
	andi t, 0x0f
	push t				;must save register 't' since it is used by 'rvbrflagfalse' also

	rvbrflagfalse Mode, esc3
	pop t
	tst t				;button released?
	breq esc5
	b16ldi Temp, 5000.0		;no, keep full throttle
	rjmp esc2

esc3:	pop t
	cpi t, 0x08			;EXIT?
	breq esc4
	b16ldi Temp, 88.8		;no, set minimum throttle level
	rjmp esc2

esc5:	b16ldi Temp, 88.8		;mode is changing, set minimum throttle level
	rvsetflagfalse Mode
	rjmp esc1

esc4:	LedOff				;done
	ret



EscCalWarning:
	call LcdClear
	lrv PixelType, 1
	lrv FontSelector, f12x16

	lrv X1, 22				;Header
	lrv Y1, 0
	mPrintString war10

	lrv X1, 0
	lrv Y1, 17
	lrv FontSelector, f6x8
	mPrintString war11

	lrv X1, 0
	lrv Y1, 26
	mPrintString war12

	lrv X1, 0
	lrv Y1, 35
	mPrintString war13

	;footer
	lrv X1, 114
	lrv Y1, 57
	mPrintString war6
	call LcdUpdate

war1:	call GetButtonsBlocking
	cpi t, 0x01				;OK?
	brne war1

	call ReleaseButtons
	ret





esc10:	.db "Calibrating ESCs...",0
esc13:	.db "EXIT",0,0
esc20:	.db "Release button to set",0
esc21:	.db "low throttle level.",0

war10:	.db 69,58,67,65,63, 65, 62, 0		;the text "WARNING" in the mangled 12x16 font

war11:	.db "ESC calibration will", 0,0
war12:	.db "fail if the leftmost", 0,0
war13:	.db "button is held down!", 0,0
war6:	.db "OK", 0,0
